% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_mu_yt_Cpp}
\alias{get_mu_yt_Cpp}
\title{Calculate the conditional means of the process}
\usage{
get_mu_yt_Cpp(obs, all_phi0, all_A, alpha_mt)
}
\arguments{
\item{obs}{a \eqn{(T \times dp)} matrix such that the i:th row contains the vector
\eqn{(y_{i-1},...,y_{i-p})} \eqn{((dp)x1)}, where \eqn{y_{i}=(y_{1i},...,y_{di})}
\eqn{(dx1)}. That is, the initial values are included but the last observations not.}

\item{all_phi0}{a \eqn{(d \times M)} matrix such that the m:th column contains the
intercept parameters of the m:th regime.}

\item{all_A}{a \eqn{(d \times dp \times M)} array such that the slice \code{[, , m]}
contains the AR matrices of the m:th regime cbinded together: \eqn{[A_{m,1}:...:A_{m,p}]}.}

\item{alpha_mt}{a \eqn{(T \times M)} matrix such that \code{[t, m]} contains the time t
transition weights of the m:th regime.}
}
\value{
a \eqn{(T \times d)} matrix such that the i:th row contains the conditional
  mean of the process.
}
\description{
Calculates the conditional means \eqn{\mu_{y,t}} of the process
}
\keyword{internal}
