% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beowulf_cluster.R
\name{beowulf_cluster}
\alias{beowulf_cluster}
\title{Defines a beowulf cluster}
\usage{
beowulf_cluster(
  cluster.ips = NULL,
  cluster.cores = NULL,
  cluster.user = Sys.info()[["user"]],
  cluster.port = "11000",
  outfile = NULL
)
}
\arguments{
\item{cluster.ips}{Character vector with the IPs of the machines in the cluster. The first machine will be considered the main node of the cluster, and will generally be the machine on which the R code is being executed. Default: \code{NULL}.}

\item{cluster.cores}{Numeric integer vector, number of cores on each machine. Default: \code{NULL}.}

\item{cluster.user}{Character string, name of the user (should be the same throughout machines), Defaults to the current system user.}

\item{cluster.port}{Character, port used by the machines in the cluster to communicate. The firewall in all computers must allow traffic from and to such port. Default: \code{"11000"}}

\item{outfile}{Where to direct the messages provided by the workers. When working on a local computer, \code{""} prints the worker's messages in the console. A text file path will append worker's messages on the given file.  Default: \verb{/dev/null} en Linux and  \verb{nul:} on windows.}
}
\value{
A list ready to be used as input for the \code{spec} argument of the function \link[parallel]{makeCluster}.
}
\description{
Defines a Beowulf cluster from the IPs of the machines in the cluster, the number of cores of each machine, and the user name. The returned cluster has to be registered with \code{doParallel::registerDoParallel()}.
}
\examples{
if(interactive()){

beowulf.cluster <- beowulf_cluster(
 cluster.ips = c(
   "10.42.0.1",
   "10.42.0.34",
   "10.42.0.104"
   ),
cluster.cores = c(7, 4, 4),
cluster.user = "blas",
cluster.port = "11000"
)


doParallel::registerDoParallel(cl = beowulf.cluster)

#PARALLELIZED foreach LOOP HERE

parallel::stopCluster(cl = beowulf.cluster)

}

}
