% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian.kernel.R
\name{gaussian.kernel}
\alias{gaussian.kernel}
\title{Gaussian Kernel}
\usage{
gaussian.kernel(sigma = 2, s = 5)
}
\arguments{
\item{sigma}{sigma (standard deviation) of kernel (defaults 2)}

\item{s}{scale defining the number of rows and columns for kernel (default 5)}
}
\value{
Symmetrical (NxN) matrix of a Gaussian distribution
}
\description{
Creates a Gaussian Kernel of specified size and sigma
}
\examples{
opar <- par()
  par(mfrow=c(2,2))
  persp(gaussian.kernel(sigma=1, s=27), theta = 135, 
        phi = 30, col = "grey", ltheta = -120, shade = 0.6, 
        border=NA )
  persp(gaussian.kernel(sigma=2, s=27), theta = 135, phi = 30,
        col = "grey", ltheta = -120, shade = 0.6, border=NA )	
  persp(gaussian.kernel(sigma=3, s=27), theta = 135, phi = 30,
        col = "grey", ltheta = -120, shade = 0.6, border=NA )	
  persp(gaussian.kernel(sigma=4, s=27), theta = 135, phi = 30,
        col = "grey", ltheta = -120, shade = 0.6, border=NA )	
 par(opar) 			
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
