% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdata.R
\name{sim_spData}
\alias{sim_spData}
\title{Simulate spatial data on unit square}
\usage{
sim_spData(n, beta, cor.fn, spParams, spvar, deltasq, family, n_binom)
}
\arguments{
\item{n}{sample size.}

\item{beta}{a \eqn{p}{p}-dimensional vector of fixed effects.}

\item{cor.fn}{a quoted keyword that specifies the correlation function used
to model the spatial dependence structure among the observations. Supported
covariance model key words are: \code{'exponential'} and \code{'matern'}.}

\item{spParams}{a numeric vector containing spatial process parameters -
e.g., spatial decay and smoothness.}

\item{spvar}{value of spatial variance parameter.}

\item{deltasq}{value of noise-to-spatial variance ratio.}

\item{family}{a character specifying the distribution of the response as a
member of the exponential family. Valid inputs are \code{'gaussian'}, \code{'poisson'},
\code{'binary'}, and \code{'binomial'}.}

\item{n_binom}{necessary only when \code{family = 'binomial'}. Must be a
vector of length \code{n} that will specify the number of trials for each
observation. If it is of length 1, then that value is considered to be the
common value for the number of trials for all \code{n} observations.}
}
\value{
a \code{data.frame} object containing the columns -
\describe{
\item{\verb{s1, s2}}{2D-coordinates in unit square}
\item{\verb{x1, x2, ...}}{covariates, not including intercept}
\item{\code{y}}{response}
\item{\code{n_trials}}{present only when binomial data is generated}
\item{\code{z_true}}{true spatial effects with which the data is generated}
}
}
\description{
Generates synthetic spatial data of different types where the
spatial co-ordinates are sampled uniformly on an unit square. Different types
include point-referenced Gaussian, Poisson, binomial and binary data. The
design includes an intercept and fixed covariates sampled from a standard
normal distribution.
}
\examples{
set.seed(1729)
n <- 10
beta <- c(2, 5)
phi0 <- 2
nu0 <- 0.5
spParams <- c(phi0, nu0)
spvar <- 0.4
deltasq <- 1
sim1 <- sim_spData(n = n, beta = beta, cor.fn = "matern",
                   spParams = spParams, spvar = spvar, deltasq = deltasq,
                   family = "gaussian")
}
\author{
Soumyakanti Pan \href{mailto:span18@ucla.edu}{span18@ucla.edu},\cr
Sudipto Banerjee \href{mailto:sudipto@ucla.edu}{sudipto@ucla.edu}
}
