% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.seroincidence.R
\name{autoplot.seroincidence}
\alias{autoplot.seroincidence}
\title{Plot the log-likelihood curve for the incidence rate estimate}
\usage{
\method{autoplot}{seroincidence}(object, log_x = FALSE, ...)
}
\arguments{
\item{object}{a \code{seroincidence} object (from \code{\link[=est.incidence]{est.incidence()}})}

\item{log_x}{should the x-axis be on a logarithmic scale (\code{TRUE}) or linear scale (\code{FALSE}, default)?}

\item{...}{unused}
}
\value{
a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
}
\description{
Plot the log-likelihood curve for the incidence rate estimate
}
\examples{
\donttest{
library(dplyr)
library(ggplot2)

xs_data <-
  sees_pop_data_pk_100

curve <-
  typhoid_curves_nostrat_100 \%>\%
  filter(antigen_iso \%in\% c("HlyE_IgA", "HlyE_IgG"))

noise <-
  example_noise_params_pk

est1 <- est.incidence(
  pop_data = xs_data,
  curve_param = curve,
  noise_param = noise,
  antigen_isos = c("HlyE_IgG", "HlyE_IgA"),
  build_graph = TRUE
)

# Plot the log-likelihood curve
autoplot(est1)
}
}
