% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Statistics.R
\name{Plot_Median_Genes}
\alias{Plot_Median_Genes}
\title{Plot Median Genes per Cell per Sample}
\usage{
Plot_Median_Genes(
  seurat_object,
  sample_col = "orig.ident",
  group_by = deprecated(),
  group.by = NULL,
  colors_use = NULL,
  dot_size = 1,
  plot_title = "Median Genes/Cell per Sample",
  y_axis_label = "Median Genes",
  x_axis_label = NULL,
  legend_title = NULL,
  x_lab_rotate = TRUE,
  color_seed = 123
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{sample_col}{Specify which column in meta.data specifies sample ID (i.e. orig.ident).}

\item{group_by}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} soft-deprecated. See \code{group.by}.}

\item{group.by}{Column in meta.data slot to group results by (i.e. "Treatment").}

\item{colors_use}{List of colors or color palette to use.  Only applicable if \code{group.by} is not NULL.}

\item{dot_size}{size of the dots plotted if \code{group.by} is not NULL.  Default is 1.}

\item{plot_title}{Plot title.}

\item{y_axis_label}{Label for y axis.}

\item{x_axis_label}{Label for x axis.}

\item{legend_title}{Label for plot legend.}

\item{x_lab_rotate}{logical.  Whether to rotate the axes labels on the x-axis.  Default is FALSE.}

\item{color_seed}{random seed for the "varibow" palette shuffle if \code{colors_use = NULL} and number of
groups plotted is greater than 36.  Default = 123.}
}
\value{
A ggplot object
}
\description{
Plot of median genes per cell per sample grouped by desired meta data variable.
}
\examples{
library(Seurat)
# Create example groups
pbmc_small$sample_id <- sample(c("sample1", "sample2"), size = ncol(pbmc_small), replace = TRUE)

# Plot
Plot_Median_Genes(seurat_object = pbmc_small, sample_col = "orig.ident",  group.by = "sample_id")

}
\concept{stats_plotting}
