% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{sheppardCorrection}
\alias{sheppardCorrection}
\title{Correction de Sheppard et variance}
\usage{
sheppardCorrection(gp.data, order = 2, population = FALSE)
}
\arguments{
\item{gp.data}{Un objet de classe grouped.data créé avec le package \code{actuar}.}

\item{order}{Choix de l'ordre pour la correction de Sheppard. Ne peut être égal qu'à 2 ou 4.}

\item{population}{Un booléen qui indique si le calcul est réalisé à partir d'une population (\code{population=TRUE}) ou à partir d'un échantillon pour estimer un paramètre d'une population (\code{population=FALSE}).}
}
\value{
Un vecteur contenant la valeur de la correction de Sheppard pour le calcul de la variance d'une distribution groupée.
}
\description{
Calcul de la correction de Sheppard pour la variance.
}
\examples{
lims <- c(40, 45, 50, 55, 60, 65, 70, 75)
counts <- c(1,2,3,4,0,0,1)
grouped.example <- actuar::grouped.data(Group = lims, Frequency = counts)
sheppardCorrection(grouped.example)
sheppardCorrection(grouped.example, order=4)

}
