% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_api.R
\name{route_stack}
\alias{route_stack}
\alias{route_stack.default}
\alias{route_stack.Route}
\alias{route_stack.AssetRoute}
\alias{route_stack.RouteStack}
\title{Combine routes in a stack}
\usage{
route_stack(x, ...)

\method{route_stack}{default}(x, ...)

\method{route_stack}{Route}(x, ...)

\method{route_stack}{AssetRoute}(x, ...)

\method{route_stack}{RouteStack}(x, ..., .after = NULL)
}
\arguments{
\item{x}{A \link{Route} or \link{RouteStack} object}

\item{...}{one or more named \link{Route} objects}

\item{.after}{Where in the stack should the new routes be placed. \code{NULL}
means place them at the end.}
}
\value{
A \link{RouteStack} object. If \code{x} is a \link{RouteStack} then this will be
returned, modified.
}
\description{
This function allows you to combine multiple routes into a stack in order to
dispatch on them until one of them returns \code{FALSE}. This allows you to have a
router that can pass a request through multiple handlers before sending it
along to the client or other middleware
}
\examples{
\dontshow{if (packageVersion("base") >= "4.1.0") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create an empty route stack
route_stack()

# Stack a route with another, returning a RouteStack
route(all = list("*" = function(...) TRUE)) |>
  route_stack(
    limit = sizelimit_route()
  )
\dontshow{\}) # examplesIf}
}
