% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliability.R
\name{reliability}
\alias{reliability}
\alias{reliability,print.reliability}
\alias{rosettaReliability_partial}
\alias{knit_print.rosettaReliability}
\alias{print.rosettaReliability}
\title{Conduct reliability analyses with output similar to jamovi and SPSS}
\usage{
reliability(
  data,
  items = NULL,
  scaleStructure = TRUE,
  descriptives = FALSE,
  itemLevel = FALSE,
  scatterMatrix = FALSE,
  scatterMatrixArgs = list(progress = FALSE),
  digits = 2,
  conf.level = 0.95,
  itemLabels = NULL,
  itemOmittedCorsWithRest = FALSE,
  itemOmittedCorsWithTotal = FALSE,
  alphaOmittedCIs = FALSE,
  omegaFromMBESS = FALSE,
  omegaFromPsych = TRUE,
  ordinal = FALSE,
  headingLevel = 3,
  ...
)

rosettaReliability_partial(
  x,
  digits = x$digits,
  headingLevel = x$headingLevel,
  printPlots = TRUE,
  echoPartial = FALSE,
  partialFile = NULL,
  quiet = TRUE,
  ...
)

\method{knit_print}{rosettaReliability}(
  x,
  digits = x$digits,
  headingLevel = x$headingLevel,
  printPlots = TRUE,
  echoPartial = FALSE,
  partialFile = NULL,
  quiet = TRUE,
  ...
)

\method{print}{rosettaReliability}(
  x,
  digits = x$digits,
  headingLevel = x$headingLevel,
  forceKnitrOutput = FALSE,
  printPlots = TRUE,
  ...
)
}
\arguments{
\item{data}{The data frame}

\item{items}{The items (if omitted, all columns are used)}

\item{scaleStructure}{Whether to include scale-level estimates using
\code{\link[ufs:scaleStructure]{ufs::scaleStructure()}}}

\item{descriptives}{Whether to include mean and standard deviation eastimates
and their confidence intervals}

\item{itemLevel}{Whether to include item-level internal consistency estimates}

\item{scatterMatrix, scatterMatrixArgs}{Whether to produce a scatter matrix,
and the arguments to pass to the \code{\link[=scatterMatrix]{scatterMatrix()}} function.}

\item{digits}{The number of digits to round the result to}

\item{conf.level}{The confidence level of confidence intervals}

\item{itemLabels}{Optionally, labels to use for the items (optionally, named,
with the names corresponding to the \code{items}; otherwise, the order of the
labels has to match the order of the items)}

\item{itemOmittedCorsWithRest, itemOmittedCorsWithTotal}{Whether to include
each item's correlations with, respectively, the scale with that item
omitted, or the full scale.}

\item{alphaOmittedCIs}{Whether to include the
confidence intervals for the Coefficient Alpha estimates with the item
omitted.}

\item{omegaFromMBESS, omegaFromPsych}{Whether to include omega from \code{MBESS}
and/or \code{psych}}

\item{ordinal}{Wheher to set \code{poly=TRUE} when calling
\code{\link[ufs:scaleStructure]{ufs::scaleStructure()}}, which will compute the polychoric correlation
matrix to provide the scale estimates assuming ordinal-level items. Note
that this may throw a variety of errors from within the \code{psych} package if
the data are somehow not what \code{psych} expects}

\item{headingLevel}{The number of hashes to print in front of the headings
when printing while knitting}

\item{...}{Any additional arguments are passed to \code{\link[ufs:scaleStructure]{ufs::scaleStructure()}} by
\code{reliability}, to the default print method by \code{print.reliability}, and to
\code{\link[rmdpartials:partial]{rmdpartials::partial()}} when knitting an RMarkdown partial.}

\item{x}{The object to print}

\item{printPlots}{Whether to print plots (can be used to suppress plots,
which can be useful sometimes)}

\item{echoPartial}{Whether to show the executed code in the R Markdown
partial (\code{TRUE}) or not (\code{FALSE}).}

\item{partialFile}{This can be used to specify a custom partial file. The
file will have object \code{x} available.}

\item{quiet}{Passed on to \code{\link[knitr:knit]{knitr::knit()}} whether it should b
chatty (\code{FALSE}) or quiet (\code{TRUE}).}

\item{forceKnitrOutput}{Force knitr output}
}
\value{
An object with all results
}
\description{
The \code{reliability()} analysis is the only one most users will need. It tries
to apply best practices by, as much as possible, complementing point
estimates with confidence intervals.
}
\details{
The \code{rosettaReliability} object that is returned has
its own \code{print()} method, that, when using \code{knitr}, will use
the \code{rmdpartials} package to insert an RMarkdown partial. That partial is
created using
\code{rosettaReliability_partial()}, which is also called by a specific
\code{knit_print()} method.
}
\examples{
### These examples aren't run during tests
### because they can take quite long
\dontrun{
### Simple example with only main reliability results
data(pp15, package="rosetta");
rosetta::reliability(
  pp15,
  c(
    "highDose_AttGeneral_good",
    "highDose_AttGeneral_prettig",
    "highDose_AttGeneral_slim",
    "highDose_AttGeneral_gezond",
    "highDose_AttGeneral_spannend"
  )
);

### More extensive example with an RMarkdown partial that
### displays in the viewer
rosetta::rosettaReliability_partial(
  rosetta::reliability(
    attitude,
    descriptives = TRUE,
    itemLevel = TRUE,
    scatterMatrix = TRUE
  )
);
}

}
