% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{export_tomic_as_triple}
\alias{export_tomic_as_triple}
\title{Export T*Omic as Triple}
\usage{
export_tomic_as_triple(tomic, dir_path, name_preamble, verbose = TRUE)
}
\arguments{
\item{tomic}{Either a \code{tidy_omic} or \code{triple_omic} object}

\item{dir_path}{path to save outputs}

\item{name_preamble}{start of output file name}

\item{verbose}{extra reporting messages}
}
\value{
Export three tables:
\itemize{
    \item{features: one row per features measured (i.e., a metabolite)}
    \item{sample: one row per sample}
    \item{measurements: one row per measurement (i.e., one metabolite in
      one sample)}
}
}
\description{
Export features, samples and measurements tables
}
\examples{
if (interactive()) {
  export_tomic_as_triple(brauer_2008_triple, "/tmp", "brauer")
}
}
