% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cran_doom.R
\name{cran_doom}
\alias{cran_doom}
\title{Calculate time till packages are archived}
\usage{
cran_doom(which = "strong", bioc = FALSE)
}
\arguments{
\item{which}{a character vector listing the types of
    dependencies, a subset of
    \code{c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}.
    Character string \code{"all"} is shorthand for that vector,
    character string \code{"most"} for the same vector without
    \code{"Enhances"},
    character string \code{"strong"} (default) for the first three
    elements of that vector.
  }

\item{bioc}{Logical value if Bioconductor packages should be provided,
(Requires internet connection).}
}
\value{
A list with multiple elements:
\itemize{
\item time_till_last: Time till last package is affected.
\item last_archived: the date of the last package that would be affected.
\item npackages: Numeric vector with the number of packages used.
\item details: A data.frame with information for each individual package:
Name, date affected, affected directly, repository, times it is affected
(by archival causing issues.)
}
}
\description{
Given the deadlines by the CRAN volunteers packages can be archived which can trigger some other packages to be archived.
This code calculates how much time the chain reaction will go on if maintainer don't fix/update the packages.
}
\details{
Packages on Suggested: field should
}
\examples{
\donttest{
cd <- cran_doom()
head(cd$details)
}
}
\references{
Original code from: \url{https://github.com/schochastics/cran-doomsday/blob/main/index.qmd}
}
\seealso{
The raw source of the data is: \code{\link[tools:CRAN_package_db]{tools::CRAN_package_db()}}

Other utilities: 
\code{\link{cran_date}()},
\code{\link{cran_snapshot}()},
\code{\link{duplicated_alias}()},
\code{\link{package_date}()},
\code{\link{package_repos}()},
\code{\link{repos_dependencies}()},
\code{\link{update_dependencies}()}
}
\concept{utilities}
