% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_flip.R
\name{redist_flip}
\alias{redist_flip}
\title{'Flip' Markov Chain Monte Carlo Redistricting Simulation (Fifield et al. 2020)}
\usage{
redist_flip(
  map,
  nsims,
  warmup = 0,
  init_plan,
  constraints = add_constr_edges_rem(redist_constr(map), 0.4),
  thin = 1,
  eprob = 0.05,
  lambda = 0,
  temper = FALSE,
  betaseq = "powerlaw",
  betaseqlength = 10,
  betaweights = NULL,
  adapt_lambda = FALSE,
  adapt_eprob = FALSE,
  exact_mh = FALSE,
  adjswaps = TRUE,
  init_name = NULL,
  verbose = TRUE,
  nthin
)
}
\arguments{
\item{map}{A \code{\link{redist_map}} object.}

\item{nsims}{The number of samples to draw, not including warmup.}

\item{warmup}{The number of warmup samples to discard.}

\item{init_plan}{A vector containing the congressional district labels
of each geographic unit. The default is \code{NULL}. If not provided,
a random initial plan will be generated using \code{redist_smc}. You can also
request to initialize using \code{redist.rsg} by supplying 'rsg', though this is
not recommended behavior.}

\item{constraints}{A \code{redist_constr} object.}

\item{thin}{The amount by which to thin the Markov Chain. The
default is \code{1}.}

\item{eprob}{The probability of keeping an edge connected. The
default is \code{0.05}.}

\item{lambda}{lambda The parameter determining the number of swaps to attempt
each iteration of the algorithm. The number of swaps each iteration is
equal to Pois(\code{lambda}) + 1. The default is \code{0}.}

\item{temper}{Whether to use simulated tempering algorithm. Default is FALSE.}

\item{betaseq}{Sequence of beta values for tempering. The default is
\code{powerlaw} (see Fifield et. al (2020) for details).}

\item{betaseqlength}{Length of beta sequence desired for
tempering. The default is \code{10}.}

\item{betaweights}{betaweights Sequence of weights for different values of
beta. Allows the user to upweight certain values of beta over
others. The default is \code{NULL} (equal weighting).}

\item{adapt_lambda}{adapt_lambda Whether to adaptively tune the lambda parameter so that the Metropolis-Hastings
acceptance probability falls between 20\% and 40\%. Default is FALSE.}

\item{adapt_eprob}{eprob Whether to adaptively tune the edgecut probability parameter so that the
Metropolis-Hastings acceptance probability falls between 20\% and 40\%. Default is
FALSE.}

\item{exact_mh}{Whether to use the approximate (FALSE) or exact (TRUE)
Metropolis-Hastings ratio calculation for accept-reject rule. Default is FALSE.}

\item{adjswaps}{Flag to restrict swaps of beta so that only
values adjacent to current constraint are proposed. The default is
\code{TRUE}.}

\item{init_name}{a name for the initial plan, or \code{FALSE} to not include
the initial plan in the output.  Defaults to the column name of the
existing plan, or "\code{<init>}" if the initial plan is sampled.}

\item{verbose}{Whether to print initialization statement. Default is \code{TRUE}.}

\item{nthin}{Deprecated. Use \code{thin}.}
}
\value{
A \code{\link{redist_plans}} object containing the simulated plans.
}
\description{
This function allows users to simulate redistricting plans
using a Markov Chain Monte Carlo algorithm (Fifield, Higgins, Imai, and Tarr 2020). Several
constraints corresponding to substantive requirements in the redistricting
process are implemented, including population parity and geographic
compactness. In addition, the function includes multiple-swap and simulated
tempering functionality to improve the mixing of the Markov Chain.
}
\details{
\code{redist_flip} allows for Gibbs constraints to be supplied via a list object
passed to \code{constraints}.
\code{redist_flip} uses a small compactness constraint by default, as this improves
the realism of the maps greatly and also leads to large speed improvements.
(One of the most time consuming aspects of the flip MCMC backend is checking for
district shattering, which is slowed down even further by non-compact districts.
As such, it is recommended that all flip simulations use at least a minimal compactness
constraint, even if you weaken it from the default settings.) The default is
a \code{compact} constraint using the \code{edges-removed} metric with a
weight of 0.6. For very small maps (< 100 precincts), you will likely want to
weaken (lower) this constraint, while for very large maps (> 5000 precincts),
you will likely want to strengthen (increase) this constraint. Otherwise,
for most maps, the default constraint should be a good starting place.

\code{redist_flip} samples from a known target distribution which can be described
using the \code{constraints}. The following describes the constraints available. The general
advice is to set weights in a way that gets between 20\% and 40\% acceptance
on average, though more tuning advice is available in the vignette on using
MCMC methods.Having too small of an acceptance rate indicates that the weights
within \code{constraints} are too large and will impact sampling efficiency.
If the Metropolis Hastings acceptance rate is too large, this may impact the
target distribution, but may be fine for general exploration of possible maps.

There are currently 9 implemented constraint types, though `\code{compact} and
\code{partisan} have sub-types which are specified via a character \code{metric}
within their respective list objects. The constraints are as follows:
\itemize{
\item \code{compact} - biases the algorithm towards drawing more compact districts.
\item weight - the coefficient to put on the Gibbs constraint
\item metric - which metric to use. Must be one of \code{edges-removed} (the default),
\code{polsby-popper}, \code{fryer-holden}, or \code{log-st}. Using Polsby Popper
is generally not recommended, as \code{edges-removed} is faster and highly correlated.
\code{log-st} can be used to match the target distribution of \code{redist_smc} or
\code{redist_mergesplit}.
\item areas - Only used with \code{polsby-popper} - A vector of precinct areas.
\item borderlength_mat - Only used with \code{polsby-popper} - A matrix of precinct
border lengths.
\item ssdmat - Only used with \code{fryer-holden} - A matrix of squared distances between
precinct centroids.
\item ssd_denom - Only used with \code{fryer-holden} - a positive integer to use
as the normalizing constant for the Relative Proximity Index.
\item \code{population} - A Gibbs constraint to complement the hard population
constraint set by \code{pop_tol}. This penalizes moves which move away from smaller
population parity deviations. It is very useful when an \code{init_plan} sits
outside of the desired \code{pop_tol} but there are substantive reasons to use
that plan. This constraint uses the input to \code{total_pop}.
\item weight - the coefficient to put on the Gibbs constraint
\item \code{countysplit} This is a Gibbs constraint to minimize county splits. Unlike
SMC's county constraint, this allows for more than \code{ndists - 1} splits and
does not require that counties are contiguous.
\item weight - the coefficient to put on the Gibbs constraint
\item \code{hinge} This uses the proportion of a group in a district and matches to the
nearest target proportion, and then creates a penalty of
\eqn{\sqrt{max(0, nearest.target - group.pct)}}.
\item weight - the coefficient to put on the Gibbs constraint
\item minorityprop - A numeric vector of minority proportions (between 0 and 1) which
districts should aim to have
\item \code{vra} This takes two target proportions of the presence of a minority group
within a district. \eqn{(|target.min - group.pct||target.other - group.pct|)^{1.5})}
\item weight - the coefficient to put on the Gibbs constraint
\item target_min - the target minority percentage. Often, this is set to 0.55 to encourage
minority majority districts.
\item target_other - the target minority percentage for non majority minority districts.
\item \code{minority} This constraint sorts the districts by the proportion of a group in
a district and compares the highest districts to the entries of minorityprop.
This takes the form \eqn{\sum_{i=1}^{n} \sqrt{|group.pct(i) - minorityprop(i)| }} where n
is the length of minorityprop input.
\item weight - the coefficient to put on the Gibbs constraint
\item minorityprop - A numeric vector of minority proportions (between 0 and 1) which
districts should aim to have
\item \code{similarity} This is a status-quo constraint which penalizes plans which
are very different from the starting place. It is useful for local exploration.
\item weight - the coefficient to put on the Gibbs constraint
\item \code{partisan} This is a constraint which minimizes partisan bias, either as
measured as the difference from proportional representation or as the magnitude of
the efficiency gap.
\item weight - the coefficient to put on the Gibbs constraint
\item rvote - An integer vector of votes for Republicans or other party
\item dvote - An integer vector of votes for Democrats or other party
\item metric - which metric to use. Must be one of \code{proportional-representation}
or \code{efficiency-gap}.
\item \code{segregation} This constraint attempts to minimize the degree of dissimilarity
between districts by group population.
\item weight - the coefficient to put on the Gibbs constraint
}
}
\examples{
data(iowa)
iowa_map <- redist_map(iowa, ndists = 4, existing_plan = cd_2010, total_pop = pop,
    pop_tol = 0.05)
sims <- redist_flip(map = iowa_map, nsims = 100)

}
\references{
Fifield, B., Higgins, M., Imai, K., & Tarr, A. (2020). Automated
redistricting simulation using Markov chain Monte Carlo. \emph{Journal of
Computational and Graphical Statistics}, 29(4), 715-728.
}
\concept{simulate}
