% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readtextgrid.R
\name{read_textgrid}
\alias{read_textgrid}
\alias{read_textgrid_lines}
\title{Read a textgrid file into a tibble}
\usage{
read_textgrid(path, file = NULL, encoding = NULL)

read_textgrid_lines(lines, file = NULL)
}
\arguments{
\item{path}{a path to a textgrid}

\item{file}{an optional value to use for the \code{file} column. For
\code{read_textgrid()}, the default is the base filename of the input file. For
\code{read_textgrid_lines()}, the default is \code{NA}.}

\item{encoding}{the encoding of the textgrid. The default value \code{NULL} uses
\code{\link[readr:encoding]{readr::guess_encoding()}} to guess the encoding of the textgrid. If an
encoding is provided, it is forwarded to \verb{[readr::locale()]} and
\verb{[readr::read_lines()]}.}

\item{lines}{alternatively, the lines of a textgrid file}
}
\value{
a tibble with one row per textgrid annotation
}
\description{
Read a textgrid file into a tibble
}
\examples{
tg <- system.file("Mary_John_bell.TextGrid", package = "readtextgrid")
read_textgrid(tg)
}
