% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{write_subScript}
\alias{write_subScript}
\title{This function is used to programatically take vectors of paramters and write suites of R parameter scripts
that will form part of a SHAPE experiment that is being built for running.  This is a wrapper for writting out
the suite of necessary scripts to form a run.}
\usage{
write_subScript(func_subScipt, func_outDir, func_inCombos, func_inParms,
  func_maxJobs, func_appLocation, func_commonArgs, func_submitArgs,
  func_remoteLocation, func_passedArgs,
  func_externalStopper = getOption("shape_external_stopFile"),
  func_sepString = getOption("shape_sepString"))
}
\arguments{
\item{func_subScipt}{This is the template script that needs to be replicated}

\item{func_outDir}{This is the filepath directory where output should be placed}

\item{func_inCombos}{This is the combinations of parameters that are to be used in the experiment.}

\item{func_inParms}{# These are additional parameters to be implemented in writing out combinations.}

\item{func_maxJobs}{This is the maximum number of individual R jobs that should be called at once
by the shell submission scripts, it can affect both local and remote server calls.}

\item{func_appLocation}{This is the filepath for R so that batch mode runs can be called.}

\item{func_commonArgs}{These are common arguments important when running the batch mode}

\item{func_submitArgs}{These are common arguments important when submitting the batch mode}

\item{func_remoteLocation}{This is a remote server location where an experiment built is to be run
it affects the filepathing called by submission scripts and the associated batch mode runs performed.}

\item{func_passedArgs}{These are arguments passed through this wrapper to inner functions.}

\item{func_externalStopper}{This is a file which exists as a flag for stopping SHAPE from trying to create
additional replicates.}

\item{func_sepString}{This is the common string used to collapse information.}
}
\value{
A character string that should indicate the experiment has been created.  Otheriwse this has failed.
}
\description{
This function is used to programatically take vectors of paramters and write suites of R parameter scripts
that will form part of a SHAPE experiment that is being built for running.  This is a wrapper for writting out
the suite of necessary scripts to form a run.
}
\section{Note}{

There is no example as this cannot work outisde of a runSHAPE call, it requires data produced by the simulation experiment.
}

