/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.Deque;
import java.util.Iterator;
import org.dmg.pmml.PMMLObject;

interface VisitContext {
    public Deque<PMMLObject> getParents();

    default public boolean hasParent() {
        Deque<PMMLObject> parents = this.getParents();
        return !parents.isEmpty();
    }

    default public PMMLObject getParent() {
        Deque<PMMLObject> parents = this.getParents();
        return parents.getFirst();
    }

    default public PMMLObject getParent(int index) {
        Deque<PMMLObject> parents = this.getParents();
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        Iterator<PMMLObject> it = parents.iterator();
        for (int i = 0; i < index; ++i) {
            it.next();
        }
        return it.next();
    }

    default public void pushParent(PMMLObject parent) {
        Deque<PMMLObject> parents = this.getParents();
        parents.addFirst(parent);
    }

    default public PMMLObject popParent() {
        Deque<PMMLObject> parents = this.getParents();
        return parents.removeFirst();
    }
}

