% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_plot.R
\name{univariate_plot}
\alias{univariate_plot}
\title{Univariate plot}
\usage{
univariate_plot(
  data,
  x,
  bins = 30,
  fill = "deepskyblue",
  pointcolor = "black",
  density = TRUE,
  densitycolor = "grey",
  alpha = 0.2,
  seed = 1234
)
}
\arguments{
\item{data}{a data frame.}

\item{x}{a variable name (without quotes).}

\item{bins}{number of histogram bins.}

\item{fill}{fill color for the histogram and boxplot.}

\item{pointcolor}{point color for the jitter plot.}

\item{density}{logical. Plot a filled density curve over the
the histogram. (default=TRUE)}

\item{densitycolor}{fill color for density curve.}

\item{alpha}{Alpha transparency (0-1) for the density curve and
jittered points.}

\item{seed}{pseudorandom number seed for jittered plot.}
}
\value{
a ggplot2 graph
}
\description{
Generates a descriptive graph for a quantitative variable.
}
\details{
\code{univariate_plot} generates a plot containing three graphs:
a histogram (with an optional density curve), a horizontal
jittered point plot, and a horizontal box plot. The \code{subtitle}
contains descriptive statistics, including the mean, standard
deviation, median, minimum, maximum, and skew.
}
\note{
The graphs are created with \link{ggplot2} and then assembled into
a single plot through the \link{patchwork} package. Missing values
are deleted.
}
\examples{
univariate_plot(mtcars, mpg)
univariate_plot(cardata, city_mpg, fill="lightsteelblue",
                pointcolor="lightsteelblue", densitycolor="lightpink",
                alpha=.6)
}
