% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densities.R
\name{densities}
\alias{densities}
\title{Density plots}
\usage{
densities(data, fill = "deepskyblue2", adjust = 1)
}
\arguments{
\item{data}{data frame}

\item{fill}{fill color for density plots}

\item{adjust}{a factor multiplied by the smoothing bandwidth. See details.}
}
\value{
a ggplot graph
}
\description{
Create desnsity plots for all quantitative variables in a data frame.
}
\details{
The \code{densities} function will only plot quantitative variables from
a data frame. Categorical variables are ignored.

The \code{adjust} parameter mulitplies the smoothing parameter. For example
\code{adjust = 2} will make the density plots twice as smooth.
The \code{adjust = 1/2} will make the density plots half as smooth (i.e., twice as spiky).
}
\examples{
densities(cars74)

densities(cars74, adjust=2)

densities(cars74, adjust=1/2)
}
