% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvarx.R
\name{as.pvarx}
\alias{as.pvarx}
\title{Coerce into a '\code{pvarx}' object}
\usage{
as.pvarx(x, w = NULL, ...)
}
\arguments{
\item{x}{A panel VAR object to be transformed.}

\item{w}{Numeric, logical, or character vector. 
\eqn{N} numeric elements weighting the individual coefficients, or 
names or \eqn{N} logical elements selecting a subset from the 
individuals \eqn{i = 1, \ldots, N} for the MG estimation. If \code{NULL} 
(the default), all \eqn{N} individuals are included without weights.}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
A list of class '\code{pvarx}'. Objects of this class contain the elements:
\item{A}{Matrix. The lined-up coefficient matrices \eqn{A_j, j=1,\ldots,p} 
  for the lagged variables in the panel VAR.}
\item{B}{Matrix. The \eqn{(K \times S)} structural impact matrix of the panel SVAR model 
  or an identity matrix \eqn{I_K} as a placeholder for the unidentified VAR model.}
\item{beta}{Matrix. The \eqn{((K+n_{d1}) \times r)} cointegrating matrix of the VAR model 
  if transformed from a rank-restricted VECM.}
\item{L.varx}{List of \code{varx} objects for the individual estimation results.}
\item{args_pvarx}{List of characters and integers 
  indicating the estimator and specifications that have been used.}
\item{args_pid}{List of characters and integers 
  indicating the identification methods and specifications that have been used. 
  This element is specific to the child-class 'pid' for panel SVAR models, 
  that inherit from parent-class 'pvarx' for any panel VAR model.}
}
\description{
Coerce into a '\code{pvarx}' object. On top of the parent class 
  '\code{pvarx}', the child class '\code{pid}' is imposed if the input object 
  to be transformed contains a panel SVAR model.
}
\details{
\code{\link{as.pvarx}} is used as an intermediary in the \strong{pvars} 
  functions to achieve compatibility with different classes of panel VAR objects.
  If the user wishes to extend this compatibility with further classes, she 
  may simply specify accordant \code{\link{as.pvarx}}-methods instead of 
  altering the original \strong{pvars} function.
}
\examples{
data("PCAP")
names_k = c("g", "k", "l", "y")  # variable names
names_i = levels(PCAP$id_i)      # country names 
L.data  = sapply(names_i, FUN=function(i) 
  ts(PCAP[PCAP$id_i==i, names_k], start=1960, end=2019, frequency=1), 
  simplify=FALSE)
  
L.vars = lapply(L.data, FUN=function(x) vars::VAR(x, p=2, type="both"))
as.pvarx(L.vars)

}
