% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliability_summary.R
\name{reliability_summary}
\alias{reliability_summary}
\title{Reliability Analysis}
\usage{
reliability_summary(
  data,
  cols,
  dimensionality = NULL,
  digits = 3,
  descriptive_table = TRUE,
  quite = FALSE,
  streamline = FALSE,
  return_result = FALSE
)
}
\arguments{
\item{data}{\code{data.frame}}

\item{cols}{items for reliability analysis.  Support \code{dplyr::select()} syntax.}

\item{dimensionality}{Specify the dimensionality. Either \code{uni} (uni-dimensionality) or \code{multi} (multi-dimensionality). Default is \code{NULL} that determines the dimensionality using EFA.}

\item{digits}{number of digits to round to}

\item{descriptive_table}{Get descriptive statistics. Default is \code{TRUE}}

\item{quite}{suppress printing output}

\item{streamline}{print streamlined output}

\item{return_result}{If it is set to \code{TRUE} (default is \code{FALSE}), it will return \code{psych::alpha} for uni-dimensional scale, and \code{psych::omega} for multidimensional scale.}
}
\value{
a \code{psych::alpha} object for unidimensional scale, and a \code{psych::omega} object for multidimensional scale.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} \cr
First, it will determine whether the data is uni-dimensional or multi-dimensional using \code{parameters::n_factors()}. If the data is uni-dimensional, then it will print a summary
consists of alpha, G6, single-factor CFA, and descriptive statistics result. If it is multi-dimensional, it will print a summary consist of alpha, G6, omega result. You can
bypass this by specifying the dimensionality argument.
}
\examples{

fit <- reliability_summary(data = lavaan::HolzingerSwineford1939, cols = x1:x3)
fit <- reliability_summary(data = lavaan::HolzingerSwineford1939, cols = x1:x9)
}
