% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teeMod.R
\name{vcov.teeMod}
\alias{vcov.teeMod}
\title{Compute variance-covariance matrix for fitted \code{teeMod} model}
\usage{
\method{vcov}{teeMod}(object, ...)
}
\arguments{
\item{object}{a fitted \code{teeMod} model}

\item{...}{additional arguments to \code{vcov_tee()}.}
}
\value{
A variance-covariance matrix with row and column entries for the estimated
coefficients in \code{x}, the marginal mean outcome in the control condition,
the marginal mean \code{offset} in the control condition (if an \code{offset}
is provided), and if a moderator variable is specified in the formula for \code{x},
the mean interaction in the control condition of the outcome and \code{offset}
with the moderator variable
}
\description{
An S3method for \code{stats::vcov} that computes standard
errors for \code{teeMod} models using \code{vcov_tee()}.
}
\details{
\code{vcov.teeMod()} wraps around \code{vcov_tee()}, so additional
arguments passed to \code{...} will be passed to the \code{vcov_tee()}
call. See documentation for \code{vcov_tee()} for information about
necessary arguments.
}
