% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es.anova.f.R
\name{es.anova.f}
\alias{es.anova.f}
\title{Cohen f effect size calculation for one- or two- way analysis of variance}
\usage{
es.anova.f(means = NULL, sd = NULL, v = TRUE)
}
\arguments{
\item{means}{A vector or matrix of group means.}

\item{sd}{The estimated standard deviation within each group.}

\item{v}{Either TRUE for verbose output or FALSE to output computed argument only.}
}
\value{
Various calculated f effect sizes.
}
\description{
Calculates teh Cohen f effect size for a one- or two-way ANOVA.
Takes as input the cell or group means for a one- or two-way ANOVA and the common
standard deviation and outputs the f effect size, as defined by Cohen (1988). Note that
this effect size calculation is only valid when cell/group sizes are equal.
}
\details{
Cohen J (1988) Statistical Power Analysis for the Behavioral Sciences, 2nd edition.
Lawrence Erlbaum Associates, Hillsdale, New Jersey
}
\examples{
es.anova.f(means = c(5, 10, 12), sd = 10)
mmatrix <- matrix(c(9.3, 8.9, 8.5, 8.7, 8.3, 7.9), nrow = 2, byrow = TRUE)
es.anova.f(means = mmatrix, sd = 2)
}
