% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{sim_multi_stage}
\alias{sim_multi_stage}
\title{Simulate Multi-Stage Data}
\usage{
sim_multi_stage(
  n,
  par = list(tau = 10, gamma = c(0, -0.2, 0.3), alpha = c(0, 0.5, 0.2, -0.5, 0.4), beta =
    c(3, -0.5, -0.5), psi = 1, xi = 0.3),
  a = function(t, x, beta, ...) {
     prob <- lava::expit(beta[1] + (beta[2] * t^2) +
    (beta[3] * x))
     stats::rbinom(n = 1, size = 1, prob = prob)
 },
  seed = NULL
)
}
\arguments{
\item{n}{Number of observations.}

\item{par}{Named list with distributional parameters.
\itemize{
\item{} \code{tau}: \eqn{\tau}
\item{} \code{gamma}: \eqn{\gamma}
\item{} \code{alpha}: \eqn{\alpha}
\item{} \code{beta}: \eqn{\beta}
\item{} \code{psi}: \eqn{\psi}
\item{} \code{xi}: \eqn{\xi}
}}

\item{a}{Function used to specify the action/treatment at every stage.}

\item{seed}{Integer.}
}
\value{
list with elements \code{stage_data} (\link[data.table:data.table]{data.table::data.table}) and
\code{baseline_data} (\link[data.table:data.table]{data.table::data.table}).
}
\description{
Simulate Multi-Stage Data
}
\details{
\code{sim_multi_stage} samples \code{n} iid observation
\eqn{O} with the following distribution:
\deqn{
W \sim \mathcal{N}(0, 1)\\
B \sim Ber(\xi)
}
For \eqn{k\geq 1} let
\deqn{
(T_k - T_{k-1})| X_{k-1}, A_{k-1}, W \sim
\begin{cases}
Exp\Big\{\exp\left(\gamma^T [1, X_{k-1}, W] \right) \Big\} + \psi \quad A_{k-1} = 1\\
\infty \quad A_{k-1} = 0
\end{cases}\\
X_{k}\mid T_k, X_{k-1}, B \sim
\begin{cases}
\mathcal{N}\left\{ \alpha^T [1, T_k, T^2_k, X_{k-1}, B], 1\right\} \quad T_k < \infty \\
0 \quad T_k = \infty
\end{cases}\\
A_k \mid X_k, T_k \sim
\begin{cases}
Ber\left\{ expit\left(\beta^T[1, T_{k}^2, X_k] \right)\right\} \quad T_k < \infty\\
0 \quad T_k = \infty,
\end{cases}
}
Note that \eqn{\psi} is the minimum increment.
}
