% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m278hlund.R
\name{m278hlund}
\alias{m278hlund}
\title{Minenergo-278. Normative heat loss of underground pipe}
\usage{
m278hlund(
  t1 = 110,
  t2 = 60,
  t0 = 5,
  insd1 = 0.1,
  insd2 = insd1,
  d1 = 0.25,
  d2 = d1,
  lambda1 = 0.09,
  lambda2 = 0.07,
  k1 = 1,
  k2 = k1,
  lambda0 = 1.74,
  z = 2,
  s = 0.55,
  len = 1,
  duration = 1
)
}
\arguments{
\item{t1}{temperature of heat carrier (water) inside the supplying pipe, [\emph{°C}].
Type: \code{\link{assert_double}}.}

\item{t2}{temperature of heat carrier (water) inside the returning pipe, [\emph{°C}].
Type: \code{\link{assert_double}}.}

\item{t0}{temperature of environment, [\emph{°C}]. For underground pipe this is
the temperature of subsoil. Type: \code{\link{assert_double}}.}

\item{insd1}{thickness of the insulator which covers the supplying pipe, [\emph{m}].
Type: \code{\link{assert_double}}.}

\item{insd2}{thickness of the insulator which covers the returning pipe, [\emph{m}].
Type: \code{\link{assert_double}}.}

\item{d1}{outside diameter of supplying pipe, [\emph{m}]. Type: \code{\link{assert_double}}.}

\item{d2}{outside diameter of returning pipe, [\emph{m}]. Type: \code{\link{assert_double}}.}

\item{lambda1}{thermal conductivity of insulator which covers the supplying pipe
[\emph{W/m/°C}]. Type: \code{\link{assert_double}}.}

\item{lambda2}{thermal conductivity of insulator which covers the returning pipe
[\emph{W/m/°C}]. Type: \code{\link{assert_double}}.}

\item{k1}{technical condition factor for insulator of supplying pipe, [].
Type: \code{\link{assert_double}}.}

\item{k2}{technical condition factor for insulator of returning pipe, [].
Type: \code{\link{assert_double}}.}

\item{lambda0}{thermal conductivity of environment, [\emph{W/m/°C}]. For underground pipe this is
the thermal conductivity of subsoil.
Type: \code{\link{assert_double}}.}

\item{z}{underground laying depth of supplying pipe, [\emph{m}].
Type: \code{\link{assert_double}}.}

\item{s}{distance between supplying and returning pipes, [\emph{m}].
Type: \code{\link{assert_double}}.}

\item{len}{length of supplying pipe, [\emph{m}].
Type: \code{\link{assert_double}}.}

\item{duration}{duration of heat loss, [\emph{hour}].
Type: \code{\link{assert_double}}.}
}
\value{
Normative heat loss of supplying underground cylindrical pipe during \code{duration}, [\emph{kcal}].
 If \code{len} of pipe is 1 \emph{m} (meter) as well as \code{duration} is set to
 1 \emph{h} (hour) (default values) then the return value is also the
 \emph{specific heat loss power}, [\emph{kcal/m/h}] and so comparable with those
 prescribed by \href{https://docs.cntd.ru/document/902148459}{Minenergo Order 325}.
 Type: \code{\link{assert_double}}.
}
\description{
Calculate normative heat loss of the supplying underground pipe as a function of construction, operation,
 and technical condition specifications according to
 Appendix 5.1 of \href{https://docs.cntd.ru/document/1200035568}{Minenergo Method 278}.
 
 This type of calculations is usually made on design stage of district
 heating network (where water is a heat carrier) and is closely
 related to building codes and regulations.
}
\details{
Details on using \code{k1} and \code{k2} are the same as for
  \code{\link{m278hlcha}}.
}
\examples{
 library(pipenostics)

 m278hlund()
 # [1] 102.6226

}
\seealso{
Other Minenergo: 
\code{\link{m278hlair}()},
\code{\link{m278hlcha}()},
\code{\link{m278insdata}},
\code{\link{m278inshcm}()},
\code{\link{m278soildata}},
\code{\link{m325beta}()},
\code{\link{m325nhl}()},
\code{\link{m325nhldata}},
\code{\link{m325testbench}}
}
\concept{Minenergo}
