% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rast.pe.ses.R
\name{rast.pe}
\alias{rast.pe}
\title{Calculate phylogenetic endemism for raster data}
\usage{
rast.pe(
  x,
  tree,
  inv.R,
  branch.length,
  full_tree_metr = TRUE,
  filename = "",
  ...
)
}
\arguments{
\item{x}{SpatRaster. A SpatRaster containing presence-absence data (0 or 1)
for a set of species. The layers (species) will be sorted according to the
tree order. See the phylo.pres function.}

\item{tree}{phylo. A dated tree.}

\item{inv.R}{SpatRaster. Inverse of range size. See \code{\link{inv.range}}}

\item{branch.length}{numeric. A Named numeric vector of branch length for
each species. See \code{\link{phylo.pres}}}

\item{full_tree_metr}{logical. Whether edge.path, branch length and number
of descendants should be calculated with the full (TRUE) or the prunned tree
(FALSE). The default is TRUE.}

\item{filename}{character. Output filename}

\item{...}{additional arguments passed for terra::app}
}
\value{
SpatRaster
}
\description{
Calculate the sum of the inverse of the range size multiplied
by the branch length for the species present in raster data.
}
\examples{
\donttest{
library(terra)
library(phyloraster)
x <- rast(system.file("extdata", "rast.presab.tif",
package = "phyloraster"))
tree <- ape::read.tree(system.file("extdata", "tree.nex",
package = "phyloraster"))
pe <- rast.pe(x = x[[1:3]], tree)
plot(pe)
}
}
\references{
Laffan, S. W., Rosauer, D. F., Di Virgilio, G., Miller, J. T.,
González‐Orozco, C. E., Knerr, N., ... & Mishler, B. D. (2016).
Range‐weighted metrics of species and phylogenetic turnover can better
resolve biogeographic transition zones. Methods in Ecology and Evolution,
7(5), 580-588.

Rosauer, D. A. N., Laffan, S. W., Crisp, M. D., Donnellan, S. C.
and Cook, L. G. (2009). Phylogenetic endemism: a new approach for
identifying geographical concentrations of evolutionary history.
Molecular ecology, 18(19), 4061-4072.
}
\author{
Gabriela Alves-Ferreira and Neander Marcel Heming
}
