% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefAll2.R
\docType{methods}
\name{coefAll2}
\alias{coefAll2}
\alias{coefAll2-method}
\title{Extract Coefficients}
\usage{
coefAll2(obj, deviance = FALSE)
}
\arguments{
\item{obj}{An object typically resulting from \code{fit_dist_pbox}.}

\item{deviance}{Logical value indicating whether to compute deviance for the fitted model.}
}
\value{
A list of coefficients, possibly including 'mu', 'sigma', 'nu', and 'tau', depending on
the model specification in \code{obj}. If \code{deviance} is TRUE, it also includes the deviance of the model.
}
\description{
This is an internal method to extract coefficients from the list of the fitted distributions
for each variable resulting from \code{\link{fit_dist_pbox}}. This method handles potential issues
with parameter extraction from the complex objects created by GAM-like models.
}
\examples{
data(SEAex)
pbx <- set_pbox(SEAex)
coefAll2(pbx@fit[[1]]$allDistrs$Thailand)
}
