% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{hyperg_test}
\alias{hyperg_test}
\title{Hypergeometric Distribution-based Hypothesis Testing}
\usage{
hyperg_test(term_genes, chosen_genes, background_genes)
}
\arguments{
\item{term_genes}{vector of genes in the selected term gene set}

\item{chosen_genes}{vector containing the set of input genes}

\item{background_genes}{vector of background genes (i.e. universal set of
genes in the experiment)}
}
\value{
the p-value as determined using the hypergeometric distribution.
}
\description{
Hypergeometric Distribution-based Hypothesis Testing
}
\details{
To determine whether the \code{chosen_genes} are enriched
(compared to a background pool of genes) in the \code{term_genes}, the
hypergeometric distribution is assumed and the appropriate p value
(the value under the right tail) is calculated and returned.
}
\examples{
hyperg_test(letters[1:5], letters[2:5], letters)
hyperg_test(letters[1:5], letters[2:10], letters)
hyperg_test(letters[1:5], letters[2:13], letters)
}
