% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_rgb.R
\name{pa_get_rgb}
\alias{pa_get_rgb}
\title{Retrieve an RGB image from a zipped Sentinel 2 file}
\usage{
pa_get_rgb(
  satellite.images,
  aoi = NULL,
  pixel.res = "10m",
  img.formats = c("jp2", "tif"),
  rgb.bands = c("B04", "B02", "B03"),
  fun = function(x) mean(x, na.rm = TRUE),
  verbose = TRUE
)
}
\arguments{
\item{satellite.images}{list of file paths to the Sentinel 2 zip files}

\item{aoi}{NULL or an sf object used to crop the RGB raster to an area of interest}

\item{pixel.res}{pixel resolution used to retrieve the RGB image. Can be one of 10m, 20m, 30m.}

\item{img.formats}{image formats to search for in the zipped file}

\item{rgb.bands}{a vector containing the order of the RGB bands}

\item{fun}{function to be applied to consolidate duplicated images}

\item{verbose}{whether to display information on the
progress of operations}
}
\value{
an object of class rgb and stars
}
\description{
Retrieve an RGB image from a zipped Sentinel 2 file
}
\details{
This is script that unzips the Sentinel 2 zipped file into a temporary folder, searches for the RGB,
and constructs a multi-band raster containing the RGB bands.
If no \sQuote{aoi} is provided, the script will construct the RGB image for the area covered by the image.
  An important detail of this function is that, if there are
  duplicated dates, the function will consolidate the data into 
  a single raster layer. The default behavior is to average the 
  layers that belong to the same date. This can be changed with the 
  'fun' argument.
}
\examples{
\donttest{
extd.dir <- system.file("extdata", package = "pacu")
## List of zipped Sentinel files in a directory
s2a.files <- list.files(extd.dir, '\\\\.zip', full.names = TRUE)
area.of.interest <- sf::st_read(file.path(extd.dir, 'cobs_a_aoi.shp'))
rgb.rast <- pa_get_rgb(satellite.images = s2a.files,
                            aoi = area.of.interest)
pa_plot(rgb.rast)
}

}
\author{
Caio dos Santos and Fernando Miguez
}
