% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Result.R
\docType{methods}
\name{dbGetStatement}
\alias{dbGetStatement}
\alias{dbGetStatement,AthenaResult-method}
\title{Get the statement associated with a result set}
\usage{
\S4method{dbGetStatement}{AthenaResult}(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbGetStatement()} returns a character.
}
\description{
Returns the statement that was passed to [dbSendQuery()]
or [dbSendStatement()].
}
\examples{
\dontrun{
# Note:
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `noctua::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name
con <- dbConnect(noctua::athena())

rs <- dbSendQuery(con, "SHOW TABLES in default")
dbGetStatement(rs)
}
}
\seealso{
\code{\link[DBI]{dbGetStatement}}
}
