# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Construct family id vector from pedigree trio information
#'
#' @description Create a vector of length n, giving the family id of
#' each subject.  If the pedigree is totally connected, then everyone
#' will end up in tree 1, otherwise the tree numbers represent the
#' disconnected subfamilies.  Singleton subjects each have unique
#' family numbers.
#'
#' No check is done to ensure that the id, fid, and mid actually refer to proper family structure.
#' References to ids in the fid and mid arguments that are not part of the id vector are considered founders.
#' @param id Numeric vector of ids
#' @param fid Numeric vector of ids of the father. This should be NA or 0 for a founder.
#' @param mid Numeric vector of ids of the mother. This should be NA or 0 for a founder.
#' @return Returns an integer vector giving the family index
#' @author Claus Ekstrom \email{ekstrom@@sund.ku.dk}
#' @keywords manip
#' @examples
#'
#' id <- 1:11
#' fid <- c(NA, NA, 1, 1, NA, 23, 45, 5, 5, 7, NA)
#' mid <- c(NA, NA, 2, 2, 65, NA, 46, 6, 6, 6, 0)
#' make_family_id(id, fid, mid)
#'
#' @export 
make_family_id <- function(id, fid, mid) {
    .Call(`_networkR_make_family_id`, id, fid, mid)
}

