% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measurement_merge.R
\name{measurement_merge}
\alias{measurement_merge}
\title{Internal function that filters environmental data for easier processing of fluxes.}
\usage{
measurement_merge(
  neon_data,
  data_code,
  data_product_id,
  measurement_name,
  qf_name
)
}
\arguments{
\item{neon_data}{Required. A list of NEON data downloaded from the utilities}

\item{data_code}{Required. Names of data product we are interpolating. (SWS = soil water, ST = soil temperature, SCO2C = soil CO2)}

\item{data_product_id}{Name of the data product 00094 = soil water, 00041 = soil temperature, 00095 = soil CO2}

\item{measurement_name}{Required. Names of column we are grabbing. (VSWCMean = soil water, soilTempMean = soil temperature, soilCO2concentrationMean = soil CO2)}

\item{qf_name}{Required. Names of qf column we are grabbing. (VSWCFinalQF = soil water, finalQF = soil temperature, finalQF = soil CO2)}
}
\value{
A data frame of the requested data.
}
\description{
Internal function. Given a set of environmental measurements, create a merged data frame of measurements and positions where the QF_flag exists (either observed or a smoothed mean measurement).
}
\author{
John Zobitz \email{zobitz@augsburg.edu}
}
