% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partables_helpers.R
\name{partables_helpers}
\alias{partables_helpers}
\alias{identical_partables}
\alias{is_partable}
\alias{same_variables}
\alias{get_partables}
\alias{to_partables}
\title{Helper Functions For \code{partables}-Class Objects}
\usage{
identical_partables(object1, object2)

is_partable(x)

same_variables(x)

get_partables(x)

to_partables(...)
}
\arguments{
\item{object1}{A \code{lavaan} parameter
table or similar object.}

\item{object2}{A \code{lavaan} parameter
table or similar object.}

\item{x}{An object to be checked.}

\item{...}{The objects to be combined.}
}
\value{
The function \code{\link[=identical_partables]{identical_partables()}}
returns either \code{TRUE} or \code{FALSE}.

The function \code{\link[=is_partable]{is_partable()}}
returns either \code{TRUE} or \code{FALSE}.

The function \code{\link[=same_variables]{same_variables()}}
returns either \code{TRUE} or \code{FALSE}.

The function \code{\link[=get_partables]{get_partables()}}
returns a \code{partables}-class
object.

The function \code{\link[=to_partables]{to_partables()}}
returns a \code{partables}-class
object, created from the objects
supplied.
}
\description{
For tasks such as comparing two parameter
tables inside a \code{partables}-class object.
}
\details{
The function \code{\link[=identical_partables]{identical_partables()}} compare two
\code{lavaan} parameter tables and see whether they
are identical. (Adapted from a similar function
in the package \code{semhelpinghands}).

The function \code{\link[=is_partable]{is_partable()}} tries
to
check whether an object is "likely"
to be a parameter table that can be
used by \code{\link[lavaan:lavaan]{lavaan::lavaan()}} and its
wrappers, such as \code{\link[lavaan:sem]{lavaan::sem()}}.

Note that there is no guarantee the
the parameter table makes sense or
will not lead to error when fitted.
It can only check whether it has the
required columns.

The function \code{\link[=same_variables]{same_variables()}}
check whether all parameter labels
in a \code{partables}-class object use
the same observed variables.

The function \code{\link[=get_partables]{get_partables()}}
extract the \code{partable} object from
a \code{model_set}-class object.

The function \code{\link[=to_partables]{to_partables()}}
combine objects to create a
\code{partables}-class object.
The objects to be combined can be
a \code{lavaan}-class object (e.g.,
the output of \code{\link[lavaan:sem]{lavaan::sem()}})
or a parameter table of \code{lavaan}.
}
\examples{

library(lavaan)
mod1 <-
"
x3 ~ x1
x2 ~ x4
"
mod2 <-
"
x2 ~ x4
x3 ~ x1
"
fit1 <- sem(mod1, dat_path_model)
fit2 <- sem(mod2, dat_path_model)
pt1 <- parameterTable(fit1)
pt2 <- parameterTable(fit2)
identical_partables(pt1, pt2)


is_partable(pt1)


out <- model_set(fit1,
                 fit_models = FALSE)
same_variables(get_partables(out))



out <- model_set(fit1,
                 fit_models = FALSE)
get_partables(out)


fit1 <- sem(mod1, dat_path_model)
fit2 <- sem(mod2, dat_path_model)
pt1 <- parameterTable(fit1)
pt2 <- parameterTable(fit2)

to_partables(fit1, fit2)
to_partables(pt1, pt2)

}
