% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_chol.R
\name{log_chol}
\alias{log_chol}
\alias{log_chol_inv}
\title{Computes the Log Cholesky Decomposition and the Inverse}
\usage{
log_chol(x)

log_chol_inv(x)
}
\arguments{
\item{x}{A positive definite matrix or a vector with a log Cholesky
decomposition.}
}
\value{
A numeric vector with the log Cholesky decomposition or a matrix with the
inverse.
}
\description{
Computes the log Cholesky decomposition and the inverse of it. The functions
are provided as the log Cholesky decomposition is used in the
parameterization of the covariance matrix.
}
\examples{
set.seed(1)
S <- drop(rWishart(1, 10, diag(10)))
log_chol(S)
stopifnot(isTRUE(all.equal(S, log_chol_inv(log_chol(S)))),
          (NCOL(S) * (NCOL(S) + 1L)) \%/\% 2L == length(log_chol(S)))

}
