% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sugar.R
\name{acqo}
\alias{acqo}
\title{Syntactic Sugar Acquisition Function Optimizer Construction}
\usage{
acqo(optimizer, terminator, acq_function = NULL, callbacks = NULL, ...)
}
\arguments{
\item{optimizer}{(\link[bbotk:OptimizerBatch]{bbotk::OptimizerBatch})\cr
\link[bbotk:OptimizerBatch]{bbotk::OptimizerBatch} that is to be used.}

\item{terminator}{(\link[bbotk:Terminator]{bbotk::Terminator})\cr
\link[bbotk:Terminator]{bbotk::Terminator} that is to be used.}

\item{acq_function}{(\code{NULL} | \link{AcqFunction})\cr
\link{AcqFunction} that is to be used.
Can also be \code{NULL}.}

\item{callbacks}{(\code{NULL} | list of \link[mlr3misc:Callback]{mlr3misc::Callback})
Callbacks used during acquisition function optimization.}

\item{...}{(named \code{list()})\cr
Named arguments passed to the constructor, to be set as parameters in the
\link[paradox:ParamSet]{paradox::ParamSet}.}
}
\value{
\link{AcqOptimizer}
}
\description{
This function allows to construct an \link{AcqOptimizer} in the spirit
of \code{mlr_sugar} from \CRANpkg{mlr3}.
}
\examples{
library(bbotk)
acqo(opt("random_search"), trm("evals"), catch_errors = FALSE)
}
