% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals-management.R
\name{gintervals.update}
\alias{gintervals.update}
\title{Updates a named intervals set}
\usage{
gintervals.update(
  intervals.set = NULL,
  intervals = "",
  chrom = NULL,
  chrom1 = NULL,
  chrom2 = NULL
)
}
\arguments{
\item{intervals.set}{name of an intervals set}

\item{intervals}{intervals or 'NULL'}

\item{chrom}{chromosome for 1D intervals set}

\item{chrom1}{first chromosome for 2D intervals set}

\item{chrom2}{second chromosome for 2D intervals set}
}
\value{
None.
}
\description{
Updates a named intervals set.
}
\details{
This function replaces all intervals of given chromosome (or chromosome
pair) within 'intervals.set' with 'intervals'. Chromosome is specified by
'chrom' for 1D intervals set or 'chrom1', 'chrom2' for 2D intervals set.

If 'intervals' is 'NULL' all intervals of given chromosome are removed from
'intervals.set'.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
intervs <- gscreen(
    "sparse_track > 0.2",
    gintervals(c(1, 2), 0, 10000)
)
gintervals.save("testintervs", intervs)
gintervals.load("testintervs")
gintervals.update("testintervs", intervs[intervs$chrom == "chr2", ][1:5, ], chrom = 2)
gintervals.load("testintervs")
gintervals.update("testintervs", NULL, chrom = 2)
gintervals.load("testintervs")
gintervals.rm("testintervs", force = TRUE)

}
\seealso{
\code{\link{gintervals.save}}, \code{\link{gintervals.load}},
\code{\link{gintervals.exists}}, \code{\link{gintervals.ls}}
}
\keyword{~intervals}
