% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.ic.sglfit.R
\name{predict.ic.panel.sglfit}
\alias{predict.ic.panel.sglfit}
\title{Computes prediction}
\usage{
\method{predict}{ic.panel.sglfit}(
  object,
  newx,
  s = c("bic", "aic", "aicc"),
  type = c("response"),
  method = c("pooled", "fe"),
  ...
)
}
\arguments{
\item{object}{fitted \code{\link{ic.panel.sglfit}} model object.}

\item{newx}{matrix of new values for x at which predictions are to be made. NOTE: \code{newx} must be a matrix, predict function does not accept a vector or other formats of newx.}

\item{s}{choose between 'bic', 'aic', and 'aicc'.}

\item{type}{type of prediction required. Only response is available. Gives predicted response for regression problems.}

\item{method}{choose between 'pooled', and 'fe'.}

\item{...}{Not used. Other arguments to predict.}
}
\value{
The object returned depends on type.
}
\description{
Similar to other predict methods, this functions predicts fitted values from a fitted sglfit object.
}
\details{
\code{s} is the new vector at which predictions are to be made. If s is not in the lambda sequence used for fitting the model, the predict function will use linear interpolation to make predictions. The new values are interpolated using a fraction of predicted values from both left and right \eqn{lambda} indices.
}
