% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotdiff}
\alias{plotdiff}
\title{plot differential results}
\usage{
plotdiff(
  res,
  level = "Genus",
  color = NULL,
  pvalue = 0.05,
  padj = NULL,
  log2FC = 0,
  size = 3,
  fontsize.x = 5,
  fontsize.y = 10,
  horiz = TRUE
)
}
\arguments{
\item{res}{differential test results from diff_test}

\item{level}{the level to plot}

\item{color}{A vector of character use specifying the color}

\item{pvalue}{pvalue threshold for significant  results}

\item{padj}{adjust p value threshold for significant  results}

\item{log2FC}{log2 Fold Change threshold}

\item{size}{size for the point}

\item{fontsize.x}{the size of x axis label}

\item{fontsize.y}{the size of y axis label}

\item{horiz}{horizontal or not (TRUE/FALSE)}
}
\value{
ggplot object
}
\description{
plot differential results
}
\examples{
 \donttest{
data("Physeq")
res <- difftest(physeq,group="group")
plotdiff(res,level="Genus",padj=0.001)
}
}
\author{
Kai Guo
}
