% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnet_requisition_list.R
\name{mnet_requisition_list}
\alias{mnet_requisition_list}
\title{Calculate a requisition list for Oklahoma Mesonet MTS files}
\usage{
mnet_requisition_list(
  stid = NULL,
  start_date = NULL,
  end_date = NULL,
  site_info = NULL,
  file_cache = NULL,
  ask = TRUE
)
}
\arguments{
\item{stid}{a character vector of four-digit station identifiers
for the Mesonet stations from which to download data}

\item{start_date}{the first date for which to download data specified in
Central Standard Time (i.e. "America/Costa_Rica") zone as a Date or POSIXt
object or a string with the format YYYY-MM-DD, where YYYY is the four-digit
year, MM is the two-digit numeric month and DD is the two-digit day of month}

\item{end_date}{the final date for which to download data specified in
Central Standard Time (i.e. "America/Costa_Rica") zone as a Date or POSIXt
object or a string with the format YYYY-MM-DD, where YYYY is the four-digit
year, MM is the two-digit numeric month and DD is the two-digit day of month}

\item{site_info}{a data frame with site and soil information for each
Oklahoma Mesonet station as returned by \link[mesonet]{mnet_site_info}. If
NULL, \link[mesonet]{mnet_site_info} will be used to download this
information internally}

\item{file_cache}{a character string providing a path to the local Mesonet
file cache. If NULL, the function will search for the local file cache and
if not found will prompt the user to create one.}

\item{ask}{whether or not to ask about creating a local Mesonet file cache}
}
\value{
a data frame containing paths for the MTS files required for the
 requested stations and dates
}
\description{
Calculate a requisition list of Mesonet Time Series (MTS) files from the
  Oklahoma Mesonet for given stations and dates
}
\examples{

\dontshow{
test_cache <- mnet_test_cache()
previous_options <- options(.mesonet_cache = test_cache)
}

mnet_requisition_list("ACME",
                      start_date = "1994-01-01",
                      end_date = "1994-01-05")

\dontshow{
unlink(test_cache)
options(previous_options)
}

}
