% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitd.R
\name{splitd}
\alias{splitd}
\title{Split-Dichotomized Regression Model}
\usage{
splitd(start.model, x_, data, id, ...)
}
\arguments{
\item{start.model}{a regression model}

\item{x_}{\link[base]{language}}

\item{data}{\link[base]{data.frame}}

\item{id}{\link[base]{logical} \link[base]{vector}, indices of training (\code{TRUE}) and test (\code{FALSE}) subjects}

\item{...}{additional parameters, currently not in use}
}
\value{
Function \code{\link[=splitd]{splitd()}} returns a \link[base]{function},
the dichotomizing rule \eqn{\mathcal{D}} based on the training set \eqn{(y_0, x_0)},
with additional attributes
\describe{
\item{\code{attr(,'p1')}}{\link[base]{double} scalar, \eqn{p_1 = \text{Pr}(\mathcal{D}(x_1)=1)}}
\item{\code{attr(,'effsize')}}{\link[base]{double} scalar, univariable regression coefficient estimate of \eqn{y_1\sim\mathcal{D}(x_1)}}
}
}
\description{
Split-dichotomized regression model.
}
\section{Split-Dichotomized Regression Model}{


Function \code{\link[=splitd]{splitd()}} performs a univariable regression model on the test set with a dichotomized predictor, using a dichotomizing rule determined by a recursive partitioning of the training set.
Specifically, given a training-test sample split,
\enumerate{
\item find the \emph{dichotomizing rule} \eqn{\mathcal{D}} of the predictor \eqn{x_0} given the response \eqn{y_0} in the training set (via function \code{\link[=node1]{node1()}});
\item fit a univariable regression model of the response \eqn{y_1} with the dichotomized predictor \eqn{\mathcal{D}(x_1)} in the test set.
}
Currently the Cox proportional hazards (\link[survival]{coxph}) regression for \link[survival]{Surv} response, logistic (\link[stats]{glm}) regression for \link[base]{logical} response and linear (\link[stats]{lm}) regression for \link[stats]{gaussian} response are supported.
}

\keyword{internal}
