/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.opres.nosum;

import choco.kernel.common.opres.nosum.INoSumCell;
import choco.kernel.common.opres.nosum.NoSumCell;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.set.SetVar;
import gnu.trove.TLinkedList;
import java.util.ListIterator;

public class NoSumList {
    private int cLoad;
    private int rLoad;
    private INoSumCell[] candidatesMap;
    private final TLinkedList<INoSumCell> candidatesList = new TLinkedList();

    public NoSumList(INoSumCell[] candidates) {
        this.candidatesMap = candidates;
    }

    public NoSumList(IntDomainVar[] candidates) {
        this.candidatesMap = new INoSumCell[candidates.length];
        for (int i = 0; i < candidates.length; ++i) {
            this.candidatesMap[i] = new NoSumCell(i, candidates[i]);
        }
    }

    public NoSumList(int[] candidates) {
        this.candidatesMap = new INoSumCell[candidates.length];
        for (int i = 0; i < candidates.length; ++i) {
            this.candidatesMap[i] = new NoSumCell(i, candidates[i]);
        }
    }

    public final void clear() {
        this.rLoad = 0;
        this.cLoad = 0;
        this.candidatesList.clear();
    }

    public final int getNbCandidates() {
        return this.candidatesList.size();
    }

    public final void fillCandidates() {
        this.clear();
        for (int i = 0; i < this.candidatesMap.length; ++i) {
            this.candidatesList.add(this.candidatesMap[i]);
            this.cLoad += this.candidatesMap[i].getVal();
        }
    }

    public final void setCandidatesFromVar(SetVar svar) {
        this.clear();
        DisposableIntIterator iter = svar.getDomain().getKernelIterator();
        while (iter.hasNext()) {
            this.rLoad += this.candidatesMap[iter.next()].getVal();
        }
        iter.dispose();
        iter = svar.getDomain().getOpenDomainIterator();
        while (iter.hasNext()) {
            int item = iter.next();
            this.candidatesList.add(this.candidatesMap[item]);
            this.cLoad += this.candidatesMap[item].getVal();
        }
        iter.dispose();
    }

    public final int getCandidatesLoad() {
        return this.cLoad;
    }

    public final int getRequiredLoad() {
        return this.rLoad;
    }

    public final int getMaximumLoad() {
        return this.rLoad + this.cLoad;
    }

    public final void remove(int item) {
        if (this.candidatesList.remove(this.candidatesMap[item])) {
            this.cLoad -= this.candidatesMap[item].getVal();
        }
    }

    public final void pack(int item) {
        this.remove(item);
        this.packRemoved(item);
    }

    public final ListIterator<INoSumCell> listIterator() {
        return this.candidatesList.listIterator();
    }

    public final void remove(ListIterator<INoSumCell> iter, int item) {
        iter.remove();
        this.cLoad -= this.candidatesMap[item].getVal();
    }

    public final void pack(ListIterator<INoSumCell> iter, int item) {
        this.remove(iter, item);
        this.packRemoved(item);
    }

    public final void undoRemove(ListIterator<INoSumCell> iter, int item) {
        iter.add(this.candidatesMap[item]);
        this.cLoad += this.candidatesMap[item].getVal();
    }

    public final void packRemoved(int item) {
        this.rLoad += this.candidatesMap[item].getVal();
    }

    public boolean noSum(int alpha, int beta) {
        if (alpha <= 0 || beta >= this.getCandidatesLoad()) {
            return false;
        }
        if (this.getCandidatesLoad() < alpha) {
            return true;
        }
        int sa = 0;
        int sb = 0;
        int sc = 0;
        INoSumCell k1 = this.candidatesList.getFirst();
        INoSumCell k2 = this.candidatesList.getLast();
        int cpt = 0;
        while (sc + k2.getVal() < alpha) {
            sc += k2.getVal();
            k2 = this.candidatesList.getPrevious(k2);
        }
        sb = k2.getVal();
        while (sa < alpha && sb <= beta) {
            k1 = this.candidatesList.getNext(k1);
            ++cpt;
            if ((sa += k1.getVal()) >= alpha) continue;
            k2 = this.candidatesList.getNext(k2);
            sb += k2.getVal();
            sc -= k2.getVal();
            while (sa + sc >= alpha) {
                k2 = this.candidatesList.getNext(k2);
                sc -= k2.getVal();
                sb += k2.getVal();
                INoSumCell k3 = k2;
                for (int i = 0; i <= cpt; ++i) {
                    k3 = this.candidatesList.getPrevious(k3);
                }
                sb -= k3.getVal();
            }
        }
        return sa < alpha;
    }
}

