% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_progeny_dosage_change.R
\name{plot_progeny_dosage_change}
\alias{plot_progeny_dosage_change}
\title{Display genotypes imputed or changed by the HMM chain given a global genotypic error}
\usage{
plot_progeny_dosage_change(
  map_list,
  error,
  verbose = TRUE,
  output_corrected = FALSE
)
}
\arguments{
\item{map_list}{a list of multiple \code{mappoly.map.list}}

\item{error}{error rate used in global error in the `calc_genoprob_error()`}

\item{verbose}{if TRUE (default), current progress is shown; if FALSE, 
no output is produced}

\item{output_corrected}{logical. if FALSE only the ggplot of the changed 
dosage is printed, if TRUE then a new corrected dosage matrix is output.}
}
\value{
A ggplot of the changed and imputed genotypic dosages
}
\description{
Outputs a graphical representation ggplot with the percent of data changed.
}
\examples{
      x <- get_submap(solcap.err.map[[1]], 1:30, reestimate.rf = FALSE)   
      plot_progeny_dosage_change(list(x), error=0.05, output_corrected=FALSE) 
      corrected_matrix <- plot_progeny_dosage_change(list(x), error=0.05, 
      output_corrected=FALSE) #output corrected

}
\author{
Jeekin Lau, \email{jzl0026@tamu.edu}, with optimization by Cristiane 
Taniguti, \email{chtaniguti@tamu.edu}
}
