% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_map_list.R
\name{extract_map}
\alias{extract_map}
\title{Extract the maker position from an object of class 'mappoly.map'}
\usage{
extract_map(input.map, phase.config = "best")
}
\arguments{
\item{input.map}{An object of class \code{mappoly.map}}

\item{phase.config}{which phase configuration should be used. "best" (default) 
will choose the maximum likelihood configuration}
}
\description{
Extract the maker position from an object of class 'mappoly.map'
}
\examples{
 x <- maps.hexafake[[1]]$info$genome.pos/1e6
 y <- extract_map(maps.hexafake[[1]])
 plot(y~x, ylab = "Map position (cM)", xlab = "Genome Position (Mbp)")
}
