% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_create.R
\name{make_motifs}
\alias{make_motifs}
\alias{create_motifs}
\title{Making motifs}
\usage{
create_motifs(n, directed = FALSE)
}
\arguments{
\item{n}{Given:
\itemize{
\item A single integer, e.g. \code{n = 10},
a one-mode network will be created.
\item A vector of two integers, e.g. \code{n = c(5,10)},
a two-mode network will be created.
\item A manynet-compatible object,
a network of the same dimensions will be created.
}}

\item{directed}{Logical whether the graph should be directed.
By default \code{directed = FALSE}.
If the opposite direction is desired,
use \code{to_redirected()} on the output of these functions.}
}
\description{
\code{create_motifs()} is used to create a list of networks that represent the
subgraphs or motifs corresponding to a certain number of nodes and direction.
Note that currently only \code{n==2} to \code{n==4} is implemented,
and the latter only for undirected networks.
}
\seealso{
Other makes: 
\code{\link{make_cran}},
\code{\link{make_create}},
\code{\link{make_ego}},
\code{\link{make_explicit}},
\code{\link{make_learning}},
\code{\link{make_play}},
\code{\link{make_random}},
\code{\link{make_read}},
\code{\link{make_stochastic}},
\code{\link{make_write}}
}
\concept{makes}
