% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random.R
\name{random_normal}
\alias{random_normal}
\title{Draw random samples from a normal (Gaussian) distribution.}
\usage{
random_normal(shape, mean = 0, stddev = 1, dtype = NULL, seed = NULL)
}
\arguments{
\item{shape}{The shape of the random values to generate.}

\item{mean}{Float, defaults to 0. Mean of the random values to generate.}

\item{stddev}{Float, defaults to 1. Standard deviation of the random values
to generate.}

\item{dtype}{Optional dtype of the tensor. Only floating point types are
supported. If not specified, \code{\link[=config_floatx]{config_floatx()}} is used,
which defaults to \code{float32} unless you configured it otherwise (via
\code{config_set_floatx(float_dtype)}).}

\item{seed}{Optional R integer or instance of
\code{\link[=random_seed_generator]{random_seed_generator()}}.
By default, the \code{seed} argument is \code{NULL}, and an internal global
\code{\link[=random_seed_generator]{random_seed_generator()}} is used. The \code{seed} argument can be
used to ensure deterministic (repeatable) random number generation.
Note that passing an integer as the \code{seed} value will produce the
same random values for each call. To generate different random
values for repeated calls, an instance of
\code{\link[=random_seed_generator]{random_seed_generator()}} must be provided as the \code{seed} value.

Remark concerning the JAX backend: When tracing functions with the
JAX backend the global \code{\link[=random_seed_generator]{random_seed_generator()}} is not
supported. Therefore, during tracing the default value \code{seed=NULL}
will produce an error, and a \code{seed} argument must be provided.}
}
\value{
A tensor of random values.
}
\description{
Draw random samples from a normal (Gaussian) distribution.
}
\seealso{
Other random: \cr
\code{\link{random_beta}()} \cr
\code{\link{random_binomial}()} \cr
\code{\link{random_categorical}()} \cr
\code{\link{random_dropout}()} \cr
\code{\link{random_gamma}()} \cr
\code{\link{random_integer}()} \cr
\code{\link{random_seed_generator}()} \cr
\code{\link{random_shuffle}()} \cr
\code{\link{random_truncated_normal}()} \cr
\code{\link{random_uniform}()} \cr
}
\concept{random}
