% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jpinfect-package.R
\docType{package}
\name{jpinfect-package}
\alias{jpinfect-package}
\alias{jpinfect}
\title{jpinfect: Japan Institute for Health Security Infectious Disease Data in R}
\description{
This package provides functions to download and post-process infectious
disease data from the Japan Institute for Health Security.
}
\section{Main Functions}{

\itemize{
  \item \code{jpinfect_url_confirmed()}: Display dataset URLs of Confirmed Cases based on Infectious Diseases Weekly Report (IDWR)
  \item \code{jpinfect_url_bullet()}: Display Infectious Diseases Weekly Report (IDWR) URLs
  \item \code{jpinfect_get_confirmed()}: Download the confirmed case datasets from the Japan Institute for Health Security (JIHS)
  \item \code{jpinfect_get_bullet()}: Download the bullet reports from the Japan Institute for Health Security (JIHS)
  \item \code{jpinfect_read_confirmed()}: Import one year or more years of confirmed dataset
  \item \code{jpinfect_read_bullet()}: Import one week or more weeks of bullet reports
  \item \code{jpinfect_merge()}: Merge multiple disease datasets into a unified data table
  \item \code{jpinfect_pivot()}: Convert data from wide format to long format for easier analysis
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/TomonoriHoshi/jpinfect}
  \item Report bugs at \url{https://github.com/TomonoriHoshi/jpinfect/issues}
}

}
\author{
\strong{Maintainer}: Tomonori Hoshi \email{tomonori.hoshi.japan@gmail.com}

Authors:
\itemize{
  \item Erina Ishigaki \email{Erina.Ishigaki1@alumni.lshtm.ac.uk}
  \item Satoshi Kaneko \email{skaneko@nagasaki-u.ac.jp}
}

}
\keyword{internal}
