% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_network.R
\name{score_network}
\alias{score_network}
\title{score_network}
\usage{
score_network(BasicData, n = 1000)
}
\arguments{
\item{BasicData}{A BasicData object.}

\item{n}{Number vector, the number of times random permutation sampling, default to 1000.}
}
\value{
A list.
}
\description{
Calculating differences in disease network characteristics before and after removal of drug targets
}
\examples{
data(drugdemo)
drug_herb <- PrepareData(drugdemo$drug_herb, from = "drug", to="herb")
herb_compound <- PrepareData(drugdemo$herb_compound, from = "herb", to="compound")
compound_target <- PrepareData(drugdemo$compound_target, from = "compound", to="target")
disease <- PrepareData(drugdemo$disease, diseaseID = "disease",from = "target", to="target")
BasicData <- CreateBasicData(drug_herb, herb_compound, compound_target, diseasenet = disease)
res <- score_network(BasicData, n = 100)
}
\author{
Yuanlong Hu
}
