% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-table.R
\name{position}
\alias{position}
\alias{position<-}
\alias{set_position}
\title{Set the table's position with respect to surrounding content}
\usage{
position(ht)

position(ht) <- value

set_position(ht, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{String. "left", "center", "right", "wrapleft" or "wrapright". Set to \code{NA} to reset to the default, which is \code{"center"}.}
}
\value{
\code{property()} returns the property value(s).
\code{set_property()} and \code{map_property()} return the modified huxtable.
}
\description{
Table position may be "left", "right" or "center". If you want text to
wrap around the table, use "wrapleft" or "wrapright".
}
\details{
\code{"wrapleft"} and \code{"wrapright"} position the table to the left or right, and allow text to
wrap around the table.
}
\examples{

set_position(jams, "left")
set_position(jams, "right")
set_position(jams, "center")

}
