% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hhm.R
\name{hhm}
\alias{hhm}
\title{Hierarchical Heatmap}
\usage{
hhm(
  df,
  ylower,
  yupper,
  xlower,
  xupper,
  values,
  rm_diag = FALSE,
  lgttl = NULL,
  bins = NULL,
  cbrks = NULL,
  cclrs = NULL,
  norm_lgd = FALSE,
  lgdps = 0,
  xttl_height = 0.15,
  yttl_width = 0.15
)
}
\arguments{
\item{df}{A data.frame with containing values with which to populate the heatmap.
The data.frame must include columns specifying the lower categories (`ylower`,
`xlower`) and upper groups (`yupper`, `xupper`) that each value corresponds to.
These categories and groups will be used to arrange and label the rows and
columns of the heatmap. It must also contain a `values` variable containing the
values used to populate the heatmap. Note that the groups will by default be
arranged alphabetically (top to bottom / left to right). The ordering of the
groups can be manually specified by converting yupper and/or xupper to factors.
In this case, the groups will be ordered based on the ordering of the factor
levels.}

\item{ylower}{A column in `df` containing the categories that will be presented
as rows along the y-axis of the heatmap.}

\item{yupper}{A column in `df` containing the groupings that will be used to
arrange the heatmap rows.}

\item{xlower}{A column in `df` containing the categories that will be presented
as columns along the x-axis of the heatmap.}

\item{xupper}{A column in `df` containing the groupings that will be used to
arrange the heatmap columns.}

\item{values}{A column in `df` containing the values used to populate the
heatmap.}

\item{rm_diag}{Do not show values for categories along the x and y axes that
are identical (defaults to `FALSE`). This is particularly useful for
origin-destination heatmaps, where the user may want to hide the diagonal
values.}

\item{lgttl}{Option to manually define legend title.}

\item{bins}{Option to break the data into a specified number of groups
(defaults to `NULL`). The thresholds between these groups will be equally
spaced between zero and the maximum value observed in `values`.}

\item{cbrks}{Vector of custom breaks, if users wish to use a discrete legend
colour scheme (defaults to `NULL`). For example, a supplied vector of `c(5,10,
20)` would break he values up into 5 ordered groups of ranges 0, 0-5, 5-10,
10-20 and 20+.}

\item{cclrs}{Vector of hexcodes, which to create a custom legend colour scheme
(defaults to `NULL`). If `cbrks` is supplied, `cclrs` must have a length
two longer than `cbrks`. If `bins` is supplied, `cclrs` must have a length
equal to the values provided to `bins`.}

\item{norm_lgd}{Normalised to between 0 and 1 in legend (defaults to `FALSE`).
Allows for consistency when comparing heatmaps across different datasets. At
present, this only works if all heatmap values are positive.}

\item{lgdps}{If using custom breaks, define the number of decimal points to
round the legend scale to (defaults to 0). If `norm_lgd` is `TRUE`, it will
default to 3.}

\item{xttl_height}{The space allocated to the group titles on the x-axis as a
proportion of the heatmap's height (defaults to 0.15).}

\item{yttl_width}{The space allocated to the group titles on the y-axis as a
proportion of the heatmap's width (defaults to 0.15).}
}
\value{
A ggplot object containing the final heatmap.
}
\description{
Creates a labelled heatmap from heirarchical data. This function is
useful if you wish to create a heatmap where the categories shown on both the x
and y axis can be grouped in some way. This heatmap will order the categories by
their assigned group and present both the categories and group labels along the
axes. An example might be a series of smaller geographies (lower categories) which
aggregate into larger geographical regions (upper groups).
}
\examples{
# Import toy demonstration dataset (see `?example_migration` for see details)
data(example_migration)

# Intial heatmap
hierarchical_heatmap = hhm(df = example_migration,
                           ylower = "Origin County",
                           xlower = "Destination County",
                           yupper = "Origin Region",
                           xupper = "Destination Region",
                           values = "Migration",
                           yttl_width = 0.22,
                           xttl_height = 0.4)

# For more details, see the package vignette at
# https://sgmmahon.github.io/hhmR/articles/hhmR_overview.html
}
