% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{cells_body}
\alias{cells_body}
\title{Location helper for targeting data cells in the table body}
\usage{
cells_body(columns = everything(), rows = everything())
}
\arguments{
\item{columns}{\emph{Columns to target}

\verb{<column-targeting expression>} // \emph{default:} \code{everything()}

The columns to which targeting operations are constrained. Can either
be a series of column names provided in \code{c()}, a vector of column indices,
or a select helper function (e.g. \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}},
\code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}).}

\item{rows}{\emph{Rows to target}

\verb{<row-targeting expression>} // \emph{default:} \code{everything()}

In conjunction with \code{columns}, we can specify which of their rows should
form a constraint for targeting operations. The default \code{\link[=everything]{everything()}}
results in all rows in \code{columns} being formatted. Alternatively, we can
supply a vector of row IDs within \code{c()}, a vector of row indices, or a
select helper function (e.g. \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}},
\code{\link[=matches]{matches()}}, \code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}). We can also use
expressions to filter down to the rows we need
(e.g., \verb{[colname_1] > 100 & [colname_2] < 50}).}
}
\value{
A list object with the classes \code{cells_body} and \code{location_cells}.
}
\description{
\code{cells_body()} is used to target the data cells in the table
body. The function can be used to apply a footnote with \code{\link[=tab_footnote]{tab_footnote()}}, to
add custom styling with \code{\link[=tab_style]{tab_style()}}, or the transform the targeted cells
with \code{\link[=text_transform]{text_transform()}}. The function is expressly used in each of those
functions' \code{locations} argument. The 'body' location is present by default in
every \strong{gt} table.
}
\section{Targeting cells with \code{columns} and \code{rows}}{


Targeting of values is done through \code{columns} and additionally by \code{rows} (if
nothing is provided for \code{rows} then entire columns are selected). The
\code{columns} argument allows us to target a subset of cells contained in the
resolved columns. We say resolved because aside from declaring column names
in \code{c()} (with bare column names or names in quotes) we can use
\strong{tidyselect}-style expressions. This can be as basic as supplying a select
helper like \code{starts_with()}, or, providing a more complex incantation like

\code{where(~ is.numeric(.x) & max(.x, na.rm = TRUE) > 1E6)}

which targets numeric columns that have a maximum value greater than
1,000,000 (excluding any \code{NA}s from consideration).

Once the columns are targeted, we may also target the \code{rows} within those
columns. This can be done in a variety of ways. If a stub is present, then we
potentially have row identifiers. Those can be used much like column names in
the \code{columns}-targeting scenario. We can use simpler \strong{tidyselect}-style
expressions (the select helpers should work well here) and we can use quoted
row identifiers in \code{c()}. It's also possible to use row indices (e.g.,
\code{c(3, 5, 6)}) though these index values must correspond to the row numbers of
the input data (the indices won't necessarily match those of rearranged rows
if row groups are present). One more type of expression is possible, an
expression that takes column values (can involve any of the available columns
in the table) and returns a logical vector.
}

\section{Examples}{


Let's use a subset of the \code{\link{gtcars}} dataset to create a \strong{gt} table. Add a
footnote (with \code{\link[=tab_footnote]{tab_footnote()}}) that targets a single data cell via the use
of \code{cells_body()} in \code{locations} (\code{rows = hp == max(hp)} will target a single
row in the \code{hp} column).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gtcars |>
  dplyr::filter(ctry_origin == "United Kingdom") |>
  dplyr::select(mfr, model, year, hp) |>
  gt() |>
  tab_footnote(
    footnote = "Highest horsepower.",
    locations = cells_body(
      columns = hp,
      rows = hp == max(hp)
    ),
    placement = "right"
  ) |>
  opt_footnote_marks(marks = c("*", "+"))
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cells_body_1.png" alt="This image of a table was generated from the first code example in the `cells_body()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-18
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other location helper functions: 
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_footnotes}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_source_notes}()},
\code{\link{cells_stub}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stub_summary}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{location-helper}}
}
\concept{location helper functions}
