% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srvf_to_f.R
\name{srvf_to_f}
\alias{srvf_to_f}
\title{Transformation from SRSF Space}
\usage{
srvf_to_f(q, time, f0 = 0)
}
\arguments{
\item{q}{Either a numeric vector of a numeric matrix or a numeric array
specifying the SRSFs that need to be transformed.
\itemize{
\item If a vector, it must be of shape \eqn{M} and it is interpreted as a
single \eqn{1}-dimensional curve observed on a grid of size \eqn{M}.
\item If a matrix, it must be of shape
\eqn{M \times N}. In this case, it is interpreted as a sample of \eqn{N}
curves observed on a grid of size \eqn{M}, unless \eqn{M = 1} in which case
it is interpreted as a single \eqn{1}-dimensional curve observed on a grid
of size \eqn{M}.
}}

\item{time}{A numeric vector of length \eqn{M} specifying the grid on which
SRSFs are evaluated.}

\item{f0}{Either a numeric value or a numeric vector of or a numeric matrix
specifying the initial value of the curves in the original functional
space. It must be:
\itemize{
\item a value if \code{q} represents a single SRSF.
\item a vector of length \eqn{N} if \code{q} represents a sample of \eqn{N} SRVFs
}}
}
\value{
A numeric array of the same shape as the input \code{q} storing the
transformation of the SRVFs \code{q} back to the original functional space.
}
\description{
This function transforms SRVFs back to the original functional space for
functions in \eqn{R^1}.
}
\examples{
q <- f_to_srvf(simu_data$f, simu_data$time)
f <- srvf_to_f(q, simu_data$time, simu_data$f[1, ])
}
\references{
Srivastava, A., Wu, W., Kurtek, S., Klassen, E., Marron, J. S.,
May 2011. Registration of functional data using fisher-rao metric,
arXiv:1103.3817v2.

Tucker, J. D., Wu, W., Srivastava, A., Generative models for
functional data using amplitude and phase separation, Computational
Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{alignment}
\keyword{srvf}
