% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texreg.R
\name{extract.ergmito}
\alias{extract.ergmito}
\title{Extract function to be used with the \code{texreg} package.}
\usage{
extract.ergmito(
  model,
  include.aic = TRUE,
  include.bic = TRUE,
  include.loglik = TRUE,
  include.nnets = TRUE,
  include.offset = TRUE,
  include.convergence = TRUE,
  include.timing = TRUE,
  ...
)
}
\arguments{
\item{model}{An object of class \code{ergmito}.}

\item{include.aic, include.bic, include.loglik}{See \link[texreg:extract]{texreg::extract}.}

\item{include.nnets}{Logical. When true, it adds the Number of networks used
to the list of gof statistics. This can be useful when running pooled models.}

\item{include.offset}{Logical. When equal to \code{TRUE}, it adds one line per
offset term to the table, omiting sd and significance.}

\item{include.convergence}{Logical. When true it, adds the convergence value
of the \link[stats:optim]{stats::optim} function (0 means convergence).}

\item{include.timing}{Logical, When true it will report the elapsed time
in seconds.}

\item{...}{Further arguments passed to the \code{\link[base:summary]{base::summary()}} of \link{ergmito}.}
}
\description{
To be used with the \CRANpkg{texreg} package. This function can be used to
generate nice looking tables of ERGMitos estimates.
}
\examples{

library(texreg)
data(fivenets)
ans <- ergmito(fivenets ~ edges + nodematch("female"))
screenreg(ans)

}
